/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.serviceaction.ServiceActionStateEngine;
import java.io.File;
import java.util.Map;

public abstract class DefaultServiceAction
extends ServiceAction {
    private static final String TRACE_MASKT = "XRVFDSAT";
    private static final String TRACE_MASKF = "XRVFDSAF";
    private static final String TRACE_MASKD = "XRVFDSAD";
    protected boolean showProgress = true;
    protected LocalizableText progressHeading = new LocalizableText("Service action progress");
    protected LocalizableText progressStart = new LocalizableText("Service action starting...");
    protected LocalizableText progressEnd = new LocalizableText("Service action ending...");
    protected int secsToShowBusy = 3;
    private String rulesFileName = null;

    public DefaultServiceAction() {
    }

    public DefaultServiceAction(PersistentData persistentData) throws ServiceActionException {
        super(persistentData);
    }

    public void setRulesFile(String rulesFileName) {
        this.rulesFileName = rulesFileName;
    }

    public void start(Map userData) throws ServiceActionException {
        this.showStarted(userData);
        try {
            if (this.rulesFileName == null) {
                Trace.trace(TRACE_MASKT, "<-! DefaultServiceAction - rules file not set");
                throw new ServiceActionException("DefaultServiceAction - rules file not set");
            }
            String completeRulesFileName = System.getProperty("CONSOLE_PATH") + "/" + this.rulesFileName;
            File rulesFile = new File(completeRulesFileName);
            ServiceActionStateEngine.fire(rulesFile, userData);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultServiceAction - Exception caught[" + e + "]");
            Trace.trace(TRACE_MASKF, e);
            if (e instanceof ServiceActionException) {
                throw (ServiceActionException)e;
            }
            throw new ServiceActionException(e);
        }
        finally {
            this.showStopped(userData);
        }
    }

    public boolean isUpgradeData() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showStarted(Map userData) {
        if (this.showProgress) {
            GenericGui displayHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            try {
                displayHandle.showBusyDialog(this.progressHeading, this.progressStart, userData);
                Thread.sleep(this.secsToShowBusy * 1000);
            }
            catch (Exception toss) {
            }
            finally {
                try {
                    displayHandle.destroyBusyDialog(userData);
                }
                catch (Exception toss) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showStopped(Map userData) {
        if (this.showProgress) {
            GenericGui displayHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            try {
                displayHandle.showBusyDialog(this.progressHeading, this.progressEnd, userData);
                Thread.sleep(this.secsToShowBusy * 1000);
            }
            catch (Exception toss) {
            }
            finally {
                try {
                    displayHandle.destroyBusyDialog(userData);
                }
                catch (Exception toss) {}
            }
        }
    }
}

